// opponent.c

#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#include "main.h"
#include "level.h"
#include "opponent.h"
#include "gworld.h"
#include "wdef.h"
#include "graphics.h"
#include "random.h"
#include "control.h"
#include "players.h"
#include "gameticks.h"
#include "blitter.h"

GWorldPtr opponentGWorld, opponentMaskWorld, opponentDrawWorld;
Rect opponentWindowZRect, opponentWindowRect;
int opponentMood, opponentFrame;
int opponentTime, glowTime[kGlows], glowFrame[kGlows], panicTime, panicFrame;
int heavyGlowArray[kGlowArraySize], glowArray[kGlowArraySize], lightGlowArray[kGlowArraySize];

void InitOpponent( void )
{
	Rect littleRect = {0, 0, 64, 64}, bigRect = {0, 0, 64, 64*(kOppFrames*3) };
	double index, value;
	
	InitGWorld( &opponentDrawWorld, &littleRect, 16 );
	InitGWorld( &opponentGWorld, &bigRect, 16 );

	bigRect.bottom *= kGlows + 1;
	InitGWorld( &opponentMaskWorld, &bigRect, 1 );
	
	opponentWindowZRect.top = opponentWindowZRect.left = 0;
	opponentWindowZRect.bottom = opponentWindowZRect.right = 64;
	opponentWindowRect = opponentWindowZRect;
	CenterRectInPort( &opponentWindowRect, backdropPort, 0.5, 0.5 );
		
	opponentMood = 0;
	
	for( index=0; index<kGlowArraySize; index++ )
	{
		value = sin( index*pi/kGlowArraySize );
		value *= value;
		
		heavyGlowArray[(int)index] = value * 24;
		glowArray[(int)index] = value * 16;
		lightGlowArray[(int)index] = value * 12;
	}
}

void BeginOpponent( int which )
{
#if 0
	Rect srcRect = {0, 0, 64, 64},
		 dstRect = {0, 0, 64, 64},
		 maskRect;
	int count, mask;
	CIconHandle opp;
	
	for( count=0; count<(kOppFrames*3); count++ )
	{
		opp = GetCIcon( 2000 + (which*100) + count );
		
		if( opp )
		{
			PrepareForGDrawing( opponentGWorld );

			CopyBits( (BitMap*) &boardWorld[0]->portPixMap,
			 		  (BitMap*) &opponentGWorld->portPixMap,
					   &srcRect,
					   &dstRect,
					   srcCopy, nil );

			PlotCIcon( &dstRect, opp );

			FinishGDrawing( opponentGWorld );
					  
			PrepareForGDrawing( opponentMaskWorld );
			
			CopyBits( (BitMap*) &((**opp).iconMask),
					  (BitMap*) &opponentMaskWorld->portPixMap,
	 				   &srcRect,
					   &dstRect,
					   srcCopy, nil );

			FinishGDrawing( opponentMaskWorld );

			DisposeCIcon( opp );
		}

		PrepareForGDrawing( opponentMaskWorld );

		maskRect = dstRect;
		for( mask = 2015; mask < (2015 + (15*kGlows)); mask += 15 )
		{			
			OffsetRect( &maskRect, 0, 64 );
			EraseRect( &maskRect );

			opp = GetCIcon( mask + (which*100) + count );
			if( opp )
			{					  				
				PlotCIcon( &maskRect, opp );
				DisposeCIcon( opp );
			}
		}

		FinishGDrawing( opponentMaskWorld );
		
		OffsetRect( &dstRect, 64, 0 );
	}
		
	MakePictRes( opponentGWorld,    "\pOpponent", which + 5000 );
	MakePictRes( opponentMaskWorld, "\pMask", which + 5100 );
	
	#warning cicn-based opponents are being used!
	
#else
	int count;

	DrawPictInGWorld( opponentGWorld,    5000 + which );
	DrawPictInGWorld( opponentMaskWorld, 5100 + which );
#endif

	opponentTime = panicTime = GameTickCount( );
	for( count=0; count<kGlows; count++ )
	{
		glowTime[count] = panicTime;
		glowFrame[count] = 0;
	}
	
	opponentMood = 0;
	emotions[0] = emotions[1] = kEmotionNeutral;
}

void DrawFrozenOpponent( void )
{
	Rect myRect = {0, 0, 64, 64};
	OffsetRect( &myRect, opponentFrame * 64, 0 );

	SetPort( backdropPort );
	CopyBits( GetPortBitMapForCopyBits(opponentGWorld),
			  GetPortBitMapForCopyBits(backdropPort),
			  &myRect,
			  &opponentWindowRect,
			  srcCopy, nil );
}

void OpponentPissed( void )
{
	opponentMood = 7;
	opponentTime = GameTickCount();
}

void OpponentChatter( Boolean on )
{
	switch( on )
	{
		case true:
			opponentMood = 5;
			opponentTime = GameTickCount();
			break;
			
		case false:
			opponentMood = 0;
			opponentTime = GameTickCount();
			break;
	}
}

void UpdateOpponent( void )
{
	Rect myRect = {0,0,64,64}, dstRect = {0,0,64,64}, maskRect;
	int emotiMap[] = {0, 1, 2, 1}, draw = false, count;
		
	if( GameTickCount( ) > opponentTime )
	{
		switch( opponentMood )
		{
			case 0: 				// Idle
				opponentTime += 60 + RandomBefore(180);
				opponentMood = RandomBefore(2) + 1;
				opponentFrame = (emotiMap[emotions[1]] * kOppFrames);
				break;
			
			case 1:					// Shifty Eyes
				opponentTime += 40 + RandomBefore(60);
				opponentMood = 0;
				opponentFrame = (emotiMap[emotions[1]] * kOppFrames) + RandomBefore(2) + 1;
				break;

			case 2:					// Blinks
				opponentTime += 3;
				opponentMood = 3;
				opponentFrame = (emotiMap[emotions[1]] * kOppFrames) + 3;
				break;
			
			case 3:					// Blinks (more)
				opponentTime += 3;
				opponentMood = 4;
				opponentFrame = (emotiMap[emotions[1]] * kOppFrames) + 4;
				break;
			
			case 4: 				// Blinks (more)
				opponentTime += 3;
				opponentMood = 0;
				opponentFrame = (emotiMap[emotions[1]] * kOppFrames) + 3;
				break;
			
			case 5:                 // Chatter (only good for tutorial)
				opponentTime += 8;
				opponentMood = 6;
				opponentFrame = 5;
				break;

			case 6:					// Chatter 2 (only good for tutorial)
				opponentTime += 8;
				opponentMood = 5;
				opponentFrame = 6;
				break;
			
			case 7:					// Pissed (when hit with punishments)
				opponentTime += 60;
				opponentFrame = 7;
				opponentMood = 0;
				break;
		}
		
		draw = true;
	}
	
	if( GameTickCount( ) > panicTime )
	{
		panicTime += 2;
		
		if( emotions[1] == kEmotionPanic )
		{
			if( ++panicFrame >= kGlowArraySize ) panicFrame = 0;
			draw = true;
		}
		else
		{
			panicFrame = 0;
		}
	}
	
	for( count=0; count<kGlows; count++ )
	{
		if( GameTickCount( ) > glowTime[count] )
		{
			glowTime[count] += character[1].glow[count].time;
			
			if( character[1].glow[count].color )
			{
				if( ++glowFrame[count] >= kGlowArraySize ) glowFrame[count] = 0;
				draw = true;
			}
			else
			{
				glowFrame[count] = 0;
			}
		}
	}
	
	if( draw )
	{
		OffsetRect( &myRect, 64*opponentFrame, 0 );

		PrepareForGDrawing( opponentDrawWorld );

		CopyBits( GetPortBitMapForCopyBits(opponentGWorld),
				  GetPortBitMapForCopyBits(opponentDrawWorld),
				  &myRect,
				  &dstRect,
				  srcCopy, nil );

		maskRect = myRect;
		for( count=0; count<kGlows; count++ )
		{
			OffsetRect( &maskRect, 0, 64 );

			if( glowFrame[count] )
			{
				if( character[1].glow[count].color & 0x8000 )
				{
					BlitColorMask( GetGWorldPixMap(opponentMaskWorld), &maskRect, &dstRect, (character[1].glow[count].color & 0x7C00) >> 10,
																					        (character[1].glow[count].color & 0x03E0) >> 5,
																					        (character[1].glow[count].color & 0x001F),
																					        heavyGlowArray[glowFrame[count]] );
				}
				else
				{
					BlitColorMask( GetGWorldPixMap(opponentMaskWorld), &maskRect, &dstRect, (character[1].glow[count].color & 0x7C00) >> 10,
																				       	    (character[1].glow[count].color & 0x03E0) >> 5,
																				            (character[1].glow[count].color & 0x001F),
																				            lightGlowArray[glowFrame[count]] );
				}
			}
		}
		
		if( panicFrame )
			BlitColorMask( GetGWorldPixMap(opponentMaskWorld), &myRect, &dstRect, 31, 31, 22, glowArray[panicFrame] );

		FinishGDrawing( opponentDrawWorld );

		SetPort( backdropPort );
		CopyBits( GetPortBitMapForCopyBits(opponentDrawWorld),
				  GetPortBitMapForCopyBits(backdropPort),
				  &opponentWindowZRect,
				  &opponentWindowRect,
				  srcCopy, nil );
	}
}
